implementation module StdMenu


//	Clean Object I/O library, version 1.0.1


import	StdBool, StdEnum
import	StdPSt
import	iostate, menuaccess, menucreate, menudefaccess, menuevent, menuhandle, menuinternal, menuitems


::	DeltaMenuSystem l p
	:==	!(MenuHandles (PSt l p)) -> !*OSToolbox -> (!MenuHandles (PSt l p),!*OSToolbox)
::	AccessMenuSystem x ps
	:==	!(MenuHandles ps) -> !*OSToolbox -> (!x,!MenuHandles ps,!*OSToolbox)
::	DeltaMenuHandle ps
	:==	!(MenuStateHandle ps) -> !*OSToolbox -> (!MenuStateHandle ps,!*OSToolbox)
::	AccessMenuHandle x ps
	:==	!(MenuStateHandle ps) -> (!x,!MenuStateHandle ps)


//	General rules to access MenuHandles:

accessMenuHandles :: !Id !(AccessMenuHandle x (PSt .l .p)) !(IOSt .l .p) -> (!Maybe x, !IOSt .l .p)
accessMenuHandles id f ioState
	# (menus,ioState)	= IOStGetDevice MenuDevice ioState
	  mHs				= MenuSystemStateGetMenuHandles menus
	  (result,msHs)		= accessmenuhandles id f mHs.mMenus
	# ioState			= IOStSetDevice (MenuSystemState {mHs & mMenus=msHs}) ioState
	= (result,ioState)
where
	accessmenuhandles :: !Id !(AccessMenuHandle x .ps) ![MenuStateHandle .ps] -> (!Maybe x,![MenuStateHandle .ps])
	accessmenuhandles id f [mH:mHs]
		| id==menu_id
		= (Just result,[mH2:mHs])
		with
			(result,mH2) = f mH1
		= (opt_result,[mH1:mHs1])
		with
			(opt_result,mHs1) = accessmenuhandles id f mHs
	where
		(menu_id,mH1)	= menuStateHandleGetMenuId mH
	accessmenuhandles _ _ _
		= (Nothing,[])

changeMenuSystemState :: !Bool !(DeltaMenuSystem .l .p) !(IOSt .l .p) -> IOSt .l .p
changeMenuSystemState redrawMenus f ioState
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	# (tb,ioState)		= getIOToolbox ioState
	  menus				= MenuSystemStateGetMenuHandles mDevice
	# (menus,tb)		= f menus tb
	  mDevice			= MenuSystemState menus
	# ioState			= IOStSetDevice mDevice ioState
	| not redrawMenus
	= setIOToolbox tb ioState
	# tb				= DrawMenuBar tb
	= setIOToolbox tb ioState

accessMenuSystemState :: !Bool !(AccessMenuSystem .x (PSt .l .p)) !(IOSt .l .p) -> (!.x,!IOSt .l .p)
accessMenuSystemState redrawMenus f ioState
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	# (tb,ioState)		= getIOToolbox ioState
	  menus				= MenuSystemStateGetMenuHandles mDevice
	# (x,menus,tb)		= f menus tb
	  mDevice			= MenuSystemState menus
	# ioState			= IOStSetDevice mDevice ioState
	| not redrawMenus
	= (x,setIOToolbox tb ioState)
	# tb				= DrawMenuBar tb
	= (x,setIOToolbox tb ioState)


//	Opening a menu for an interactive process.

class Menus mdef
where
	openMenu	:: .ls !(mdef .ls (PSt .l .p)) !(PSt .l .p)	-> (!ErrorReport,!PSt .l .p)
	getMenuType	::      (mdef .ls .ps)						-> MenuType

instance Menus (Menu m)	| MenuElements m
where
	openMenu :: .ls !(Menu m .ls (PSt .l .p)) !(PSt .l .p) -> (!ErrorReport,!PSt .l .p)	| MenuElements m
	openMenu ls mDef pState
		# (isZero,pState)	= accPIO checkZeroMenuBound pState
		| isZero
		= (ErrorViolateDI,pState)
		# (optMenuId,mDef)	= menuDefGetMenuId mDef
		| isJust optMenuId && fromJust optMenuId==WindowMenuId
		= (ErrorIdsInUse,pState)
		= accPIO (OpenMenu` optMenuId ls mDef) pState
	
	getMenuType :: (Menu m .ls .ps) -> MenuType | MenuElements m
	getMenuType _
		= "Menu"

checkZeroMenuBound :: !(IOSt .l .p) -> (!Bool,!IOSt .l .p)
checkZeroMenuBound ioState
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	  mHs				= MenuSystemStateGetMenuHandles mDevice
	  (bound,mHs)		= (\msHs=:{mNrMenuBound}->(mNrMenuBound,msHs)) mHs
	# ioState			= IOStSetDevice (MenuSystemState mHs) ioState
	= (zeroBound bound,ioState)


//	Closing a menu.

closeMenu :: !Id !(IOSt .l .p) -> IOSt .l .p
closeMenu id ioState
	| id==WindowMenuId
	= ioState
	= closemenu id ioState


//	Enabling and Disabling of the MenuSystem:

enableMenuSystem :: !(IOSt .l .p) -> IOSt .l .p
enableMenuSystem ioState
	# (optModal,ioState)	= IOStGetIOIsModal ioState
	# (ioId,    ioState)	= IOStGetIOId ioState
	  modalId				= fromJust optModal
	| isJust optModal && ioId==modalId
	= ioState
	= changeMenuSystemState True enablemenusystem ioState
where
	enablemenusystem :: !(MenuHandles .ps) !*OSToolbox -> (!MenuHandles .ps,!*OSToolbox)
	enablemenusystem menus=:{mEnabled,mMenus,mOSMenuBar} tb
		| mEnabled
		= (menus,tb)
		# (mHs,tb)	= enablemenus 0 mOSMenuBar mMenus tb
		= ({menus & mMenus=mHs,mEnabled=SystemAble}, tb)
	where
		enablemenus :: !Int !OSMenuBar ![MenuStateHandle .ps] !*OSToolbox -> (![MenuStateHandle .ps],!*OSToolbox)
		enablemenus zIndex osMenuBar [msH:msHs] tb
			# (msH, tb)	= enablemenu zIndex      osMenuBar msH tb
			# (msHs,tb)	= enablemenus (zIndex+1) osMenuBar msHs tb
			= ([msH:msHs],tb)
		where
			enablemenu :: !Int !OSMenuBar !(MenuStateHandle .ps) !*OSToolbox -> (!MenuStateHandle .ps,!*OSToolbox)
			enablemenu zIndex osMenuBar msH tb
				# (select,msH)	= menuStateHandleGetSelect msH
				| not select
				= (msH,tb)
				= (msH,setSelectMenu Able zIndex osMenuBar tb)
		enablemenus _ _ msHs tb
			= (msHs,tb)

disableMenuSystem :: !(IOSt .l .p) -> IOSt .l .p
disableMenuSystem ioState
	= changeMenuSystemState True disablemenusystem ioState
where
	disablemenusystem :: !(MenuHandles .ps) !*OSToolbox -> (!MenuHandles .ps,!*OSToolbox)
	disablemenusystem menus=:{mEnabled,mMenus,mOSMenuBar} tb
		| not mEnabled
		= (menus,tb)
		# (nrMenus,msHs)= Ulength mMenus
		  indices		= [0..nrMenus-1]
		  tb			= StrictSeq [setSelectMenu Unable i mOSMenuBar \\ i<-indices] tb
		= ({menus & mMenus=msHs,mEnabled=SystemUnable},tb)

setSelectMenu :: !SelectState !Int !OSMenuBar !*OSToolbox -> *OSToolbox
setSelectMenu select zIndex osMenuBar tb
	| enabled select
		= OSEnableMenu  zIndex osMenuBar tb	// PA: was: EnableItem  menu 0 tb
		= OSDisableMenu zIndex osMenuBar tb	// PA: was: DisableItem menu 0 tb


//	Enabling and Disabling of Menus:

enableMenus :: ![Id] !(IOSt .l .p) -> IOSt .l .p
enableMenus ids ioState
	# ids	= filter ((<>) WindowMenuId) ids
	| isEmpty ids
	= ioState
	= enablemenus ids ioState

disableMenus :: ![Id] !(IOSt .l .p) -> IOSt .l .p
disableMenus ids ioState
	# ids	= filter ((<>) WindowMenuId) ids
	| isEmpty ids
	= ioState
	= disablemenus ids ioState


//	Get the SelectState of a menu: 

getMenuSelectState :: !Id !(IOSt .l .p) -> (!Maybe SelectState,!IOSt .l .p)
getMenuSelectState id ioState
	# (optSelect,ioState)	= accessMenuHandles id menuStateHandleGetSelect ioState
	| isNothing optSelect
	= (Nothing,		ioState)
	| fromJust optSelect
	= (Just Able,	ioState)
	= (Just Unable,	ioState)


/*	Adding menu elements to (sub/radio)menus:
		Items in a (sub/radio)menu are positioned starting from 1 and increasing by 1.
		Open with a position less than 1 adds the new elements in front
		Open with a position higher than the number of items adds the new elements to
		the end.
		Open an item on a position adds the item AFTER the item on that position.
*/
/*	PA: openMenuElements should actually be defined using accessMenuSystemState, but is not due to uniqueness type problems:
openMenuElements :: !Id !Index .ls (m .ls (PSt .l .p)) !(IOSt .l .p) -> (!ErrorReport,!IOSt .l .p)	| MenuElements m
openMenuElements mId pos ls new ioState
	# (pid,ioState)			= IOStGetIOId ioState
	# (rt,ioState)			= IOStGetReceiverTable ioState
	# ((error,rt),ioState)	= accessMenuSystemState True (addMenusItems (mId,Nothing) (max 0 pos) ls new pid rt) ioState
	# ioState				= IOStSetReceiverTable rt ioState
	= (error,ioState)
*/
openMenuElements :: !Id !Index .ls (m .ls (PSt .l .p)) !(IOSt .l .p) -> (!ErrorReport,!IOSt .l .p)	| MenuElements m
openMenuElements mId pos ls new ioState
	# (pid,  ioState)		= IOStGetIOId ioState
	# (rt,   ioState)		= IOStGetReceiverTable ioState
	# (tb,   ioState)		= getIOToolbox ioState
	# (mDevice,ioState)		= IOStGetDevice MenuDevice ioState
	  menus					= MenuSystemStateGetMenuHandles mDevice
	# ((error,rt),menus,tb)	= addMenusItems (mId,Nothing) (max 0 pos) ls new pid rt menus tb
	  mDevice				= MenuSystemState menus
	# ioState				= IOStSetDevice mDevice ioState
	# ioState				= setIOToolbox (DrawMenuBar tb)	ioState
	# ioState				= IOStSetReceiverTable rt ioState
	= (error,ioState)


/*	PA: openSubMenuElements should actually be defined using accessMenuSystemState, but is not due to uniqueness type problems:
openSubMenuElements :: !Id !Id !Index .ls (m .ls (PSt .l .p)) !(IOSt .l .p) -> (!ErrorReport,!IOSt .l .p)	| MenuElements m
openSubMenuElements mId sId pos ls new ioState
	# (pid,ioState)			= IOStGetIOId ioState
	# (rt,ioState)			= IOStGetReceiverTable ioState
	# ((error,rt),ioState)	= accessMenuSystemState True (addMenusItems (mId,Just sId) (max 0 pos) ls new pid rt) ioState
	# ioState				= IOStSetReceiverTable rt ioState
	= (error,ioState)
*/
openSubMenuElements :: !Id !Id !Index .ls (m .ls (PSt .l .p)) !(IOSt .l .p) -> (!ErrorReport,!IOSt .l .p)	| MenuElements m
openSubMenuElements mId sId pos ls new ioState
	# (pid,  ioState)		= IOStGetIOId ioState
	# (rt,   ioState)		= IOStGetReceiverTable ioState
	# (tb,   ioState)		= getIOToolbox ioState
	# (mDevice,ioState)		= IOStGetDevice MenuDevice ioState
	  menus					= MenuSystemStateGetMenuHandles mDevice
	# ((error,rt),menus,tb)	= addMenusItems (mId,Just sId) (max 0 pos) ls new pid rt menus tb
	  mDevice				= MenuSystemState menus
	# ioState				= IOStSetDevice mDevice ioState
	# ioState				= setIOToolbox (DrawMenuBar tb)	ioState
	# ioState				= IOStSetReceiverTable rt ioState
	= (error,ioState)

openRadioMenuItems :: !Id !Id !Index ![MenuRadioItem (PSt .l .p)] !(IOSt .l .p) -> (!ErrorReport,!IOSt .l .p)
openRadioMenuItems mId rId pos radioItems ioState
	| isEmpty radioItems
	= (NoError,ioState)
	= accessMenuSystemState True (addMenuRadioItems (mId,rId) (max 0 pos) radioItems) ioState


//	Removing menu elements from (sub/radio)menus:

closeMenuElements :: !Id ![Id] !(IOSt .l .p) -> IOSt .l .p
closeMenuElements mId ids ioState
	# ids	= filter (\id->not (isSpecialId id)) ids
	| isEmpty ids
	= ioState
	= closemenuelements mId ids ioState


//	Removing menu elements from (sub/radio)menus by index (counting from 1):

closeMenuIndexElements :: !Id ![Index] !(IOSt .l .p) -> IOSt .l .p
closeMenuIndexElements mId indices ioState
	= closemenuindexelements NotRemoveSpecialMenuElements False (mId,Nothing) indices ioState

closeSubMenuIndexElements :: !Id !Id ![Index] !(IOSt .l .p) -> IOSt .l .p
closeSubMenuIndexElements mId sId indices ioState
	= closemenuindexelements NotRemoveSpecialMenuElements False (mId,Just sId) indices ioState

closeRadioMenuIndexElements :: !Id !Id ![Index] !(IOSt .l .p) -> IOSt .l .p
closeRadioMenuIndexElements mId rId indices ioState
	= closemenuindexelements NotRemoveSpecialMenuElements True (mId,Just rId) indices ioState


//	Determine the Ids and MenuTypes of all menus.

getMenus :: !(IOSt .l .p) -> (![(Id,MenuType)],!IOSt .l .p)
getMenus ioState
	# (menus,ioState)	= IOStGetDevice MenuDevice ioState
	  mHs				= MenuSystemStateGetMenuHandles menus
	  (idtypes,msHs)	= AccessList getIdType mHs.mMenus
	# ioState			= IOStSetDevice (MenuSystemState {mHs & mMenus=msHs}) ioState
	= (tl idtypes,ioState)
where
	getIdType :: !(MenuStateHandle .ps) -> ((Id,MenuType),!MenuStateHandle .ps)
	getIdType msH
		# (id,msH)		= menuStateHandleGetMenuId msH
		= ((id,"Menu"),msH)


//	Determine the index position of a menu.

getMenuPos :: !Id !(IOSt .l .p) -> (!Maybe Index,!IOSt .l .p)
getMenuPos id ioState
	# (menus,ioState)	= IOStGetDevice MenuDevice ioState
	  mHs				= MenuSystemStateGetMenuHandles menus
	  (optIndex,msHs)	= getmenuindex id 0 mHs.mMenus
	# ioState			= IOStSetDevice (MenuSystemState {mHs & mMenus=msHs}) ioState
	= (optIndex,ioState)
where
	getmenuindex :: !Id !Int ![MenuStateHandle .ps] -> (!Maybe Int,![MenuStateHandle .ps])
	getmenuindex id index [mH:mHs]
		# (menu_id,mH)	= menuStateHandleGetMenuId mH
		| id==menu_id
		= (Just index,[mH:mHs])
		# (optIndex,mHs)= getmenuindex id (index+1) mHs
		= (optIndex, [mH:mHs])
	getmenuindex _ _ _
		= (Nothing,[])


//	Set & Get the title of a menu.

setMenuTitle :: !Id !Title !(IOSt .l .p) -> IOSt .l .p
setMenuTitle id title ioState
	| id==WindowMenuId
		= ioState
		= setmenutitle id title ioState

getMenuTitle :: !Id !(IOSt .l .p) -> (!Maybe Title,!IOSt .l .p)
getMenuTitle id ioState
	= accessMenuHandles id menuStateHandleGetTitle ioState
